/*------------------------------------------------------------------------------*
 * File Name: ImpWizSource.h													*
 * Creation: GJL 7/11/2001														*
 * Purpose: Origin C file containing Application Utilities						*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Danice 12/15/03 v7.5783 CALL_SHEET_FUNCTION									*
 * Danice 12/15/03 v7.5783 DATAFILENAME_REPLACE									*
 * Danice 12/23/03 v7.5786 VARIABLE_CHANGE										*
 * Danice 12/25/03 v7.5788 NOTUSE_SHOW											*
 * Danice 12/26/03 v7.5789 SAVE_CHANGE											*
 * Danice 12/31/03 v7.5790 FOR_NEW_DIALOG_CONSTRUCTOR							*
 * EJP 01-07-2004 v7.5796 FIX_SOURCE_PAGE_EVENTS								*
 * Danice 1/17/04 v8.0802 FOR_CONTROL_UPGRADE_DATA								*
 * Danice 3/1/04 v8.0828 PAGE_INIT_ONCE											*
 * EJP 03-30-2004 v7.5826 QA70-6188 CHECK_FILE_FOR_READING						*
 * EJP 06-08-2004 v8.0886 QA70-5417 IMPROVE_DATA_CHANGE_DETECTION				*
 * EJP 07-07-2004 v8.0903 QA70-6555 SUPPORT_WORKBOOK_IMPWIZ						*
 * EJP 11-11-2004 v8.0163 QA70-6554 EXTRACT_VARS_FROM_FILENAME					*
 * SY 01/04/2005 QA70-6555 v8.0181 USING_MULTI_OPEN_FDLOG						*
 * EJP 01-04-2005 v8.0181 QA70-6555 NEW_IMPORT_MODES							*
 * EJP 2005-08-15 v8.0288 QA70-7996 IMPWIZ_SUPPORT_XFUNC						*
 * Hong 02/27/07 QA80-9410 MORE_RENAME_WORKSHEET_WITH_VARIABLE					*
 * Sim 03-06-2007 MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF							*
 * Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME		*
 *	Folger 10/19/2010 ORG-1279 DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE				*
 *------------------------------------------------------------------------------*/

#define ON_PAGE_CHECK_SOURCE


// Derived WizPage class for WizPage1
class ImpWizSourcePage : public ImpWizardPage
{
	// Constructor for ImpWizSourcePage class, use parent constructor
	//ImpWizSourcePage(int nID) : ImpWizardPage(nID) {}
	
public:
	
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitSource)
		PAGE_ON_ACTIVE(OnActiveSource)
		PAGE_ON_KILLACTIVE(OnKillActive_Source)
	
		ON_BN_CLICKED(IDC_DATATYPE_ASCII, OnClickDataType_Source)
		/// EJP 01-07-2004 v7.5796 FIX_SOURCE_PAGE_EVENTS
		ON_BN_CLICKED(IDC_DATATYPE_BINARY, OnClickDataType_Source)
		ON_BN_CLICKED(IDC_DATATYPE_USERDEF, OnClickDataType_Source)
		/// end FIX_SOURCE_PAGE_EVENTS
		
		ON_BN_CLICKED(IDC_DATATYPE_XFUNC, OnClickDataType_Source) /// EJP 2005-08-15 v8.0288 QA70-7996 IMPWIZ_SUPPORT_XFUNC
		
		ON_BN_CLICKED(IDC_SOURCE_FILE, OnClickDataFrom_Source)
		ON_BN_CLICKED(IDC_SOURCE_CLIPBOARD, OnClickDataFrom_Source) /// EJP 01-07-2004 v7.5796 FIX_SOURCE_PAGE_EVENTS
		
		ON_BN_CLICKED(IDC_SOURCE_BROWSE, OnClickBrowse_Source)
		/// EJP 11-11-2004 v8.0163 QA70-6554 EXTRACT_VARS_FROM_FILENAME, move to new page
		///ON_BN_CLICKED(IDC_IW_SOURCE_RENAMEWKS, OnClickRenameWks_Source)
		///ON_BN_CLICKED(IDC_IW_FILENAME_TO_WKSLABEL, OnClickFileNameToWksLabel_Source)
		/// end EXTRACT_VARS_FROM_FILENAME
		/// EJP 01-04-2005 v8.0181 QA70-6555 NEW_IMPORT_MODES
		///ON_EN_CHANGE(IDC_SOURCE_FILENAME, OnChangeFileName_Source)
		ON_CBN_EDITCHANGE(IDC_SOURCE_FILENAME, OnChangeFileName_Source)
		ON_CBN_SELCHANGE(IDC_SOURCE_FILENAME, OnSelChangeFileName)
		/// end NEW_IMPORT_MODES
		/// SY 01/06/2005 v8.0183 QA70-6555 USING_MULTI_OPEN_FDLOG
		ON_CBN_DROPDOWN(IDC_SOURCE_FILENAME, OnDropDownFileName)
		/// end USING_MULTI_OPEN_FDLOG
		
		ON_BN_CLICKED(IDC_TARGET_WKS, OnClickTargetWindow_Source)
		ON_BN_CLICKED(IDC_TARGET_MATRIX, OnClickTargetWindow_Source)
		ON_BN_CLICKED(IDC_TARGET_WND_NONE, OnClickTargetWindow_Source)
	
		/// EJP 10-27-2003 v7.5733 QA70-5238 DO_NOT_RESET_TARGET_WINDOW_TEMPLATE
		///ON_CBN_SELCHANGE(IDC_TARGET_WKS_TEMPLATE, Source_OnSelChangeWksTemplate)
		ON_CBN_SELCHANGE(IDC_TARGET_WKS_TEMPLATE, OnSelChangeTargetWindowTemplate_Source)
		/// end DO_NOT_RESET_TARGET_WINDOW_TEMPLATE
	
		ON_BN_CLICKED(IDC_DISPLAY_ONLY_COMPATIBLE_CHK, OnClickDisplayCompatibleFilters_Source)
		ON_CBN_SELCHANGE(IDC_SOURCE_FILTER, OnSelChangeFilter_Source)
		
		/// EJP 11-11-2004 v8.0163 QA70-6554 EXTRACT_VARS_FROM_FILENAME, move to new page
		///	/// EJP 07-19-2004 v8.0911 QA70-6555 SUPPORT_WORKBOOK_IMPWIZ
		///	ON_BN_CLICKED(IDC_SRC_REN_WKBK, OnClickRenameWorkbook)
		///	ON_BN_CLICKED(IDC_SRC_APPEND_TO_COL_COMMENTS, OnClickFileNameToColComments)
		///	ON_BN_CLICKED(IDC_SRC_REMOVE_FNAME_PATH, OnClickIncludeFileNamePath)
		///	/// end SUPPORT_WORKBOOK_IMPWIZ
		/// end EXTRACT_VARS_FROM_FILENAME
	EVENTS_END

	///Danice 12/25/03 v7.5788 NOTUSE_SHOW
	DWORD    OnShowStatus(DWORD InternalStatus);
	///END NOTUSE_SHOW

	//Events handles
	bool OnInitSource();		///Danice 12/12/03 v7.5780 CHANGE_SOME_FUNCTION_NAME

protected :
	void Source_EnableDataSourceCtrls();
	
	void Source_EnableFileCtrls(BOOL bEnable=true);
	
	void Source_EnableTargetWindowCtrls();
	
	void Source_UpdateButtons();
	
	void Source_UpdateFilterComboBox();

	void Source_UpdateFilterComboBoxList(int iFilterType, LPCSTR lpcszDataFile);
	
	void Source_UpdateFilterComboBoxSel(int iFilterType, LPCSTR lpcszDataFile);
	
	int Source_FindFirstCompatibleFilter(int iFilterType, LPCSTR lpcszDataFile);
	
	void Source_LoadCurSelFilter();
	
	void	Source_UpdateFilter(BOOL bDlgToFilter=TRUE);

	BOOL OnActiveSource();
	
	BOOL OnKillActive_Source();
	
	BOOL OnClickDataType_Source(Control Cntrl);
	
	BOOL OnClickDataFrom_Source(Control ctrl);
	
	BOOL OnClickBrowse_Source(Control ctrl);
	
	/// EJP 11-11-2004 v8.0163 QA70-6554 EXTRACT_VARS_FROM_FILENAME, move to new page
	/*
	BOOL OnClickRenameWks_Source(Control ctrl);
	
	BOOL OnClickFileNameToWksLabel_Source(Control ctrl);

	/// EJP 07-19-2004 v8.0911 QA70-6555 SUPPORT_WORKBOOK_IMPWIZ
	BOOL OnClickRenameWorkbook(Control ctrl);
	
	BOOL OnClickFileNameToColComments(Control ctrl);

	BOOL OnClickIncludeFileNamePath(Control ctrl);
	*/
	/// end EXTRACT_VARS_FROM_FILENAME
	
	BOOL OnChangeFileName_Source(Control ctrl);

	/// EJP 01-04-2005 v8.0181 QA70-6555 NEW_IMPORT_MODES
	BOOL OnSelChangeFileName(Control ctrl);
	/// end NEW_IMPORT_MODES

	/// SY 01/06/2005 v8.0183 QA70-6555 USING_MULTI_OPEN_FDLOG
	BOOL OnDropDownFileName(Control ctrl);
	/// end USING_MULTI_OPEN_FDLOG
	
	BOOL OnClickTargetWindow_Source(Control ctrl);

	BOOL OnSelChangeTargetWindowTemplate_Source(Control ctrl);
	
	BOOL	OnClickDisplayCompatibleFilters_Source(Control ctrl);
	
	//--------------------------------------------------------------------------
	// Source_OnSelChangeFilter
	//
	// DialogBuilder calls this function when the selection in the filter
	// combobox is changed.
	//--------------------------------------------------------------------------
	bool	OnSelChangeFilter_Source(Control ctrl);
	
	void Source_UpdateTargetWindowTemplateList();
	
	int Source_GetTargetWindowType();

	///------ Folger 10/19/2010 ORG-1279 DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE
	void	CheckResizeFilterControl();
	///------ End DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE
	
private :
	// Data member controls on WizPage1
	
	Button 	m_btnBrowse ;
	Button 	m_chkCompatibleFilters ;
///	Button 	m_chkFileNameToWksLabel ;
	Button 	m_chkMat ;
	/// EJP 11-11-2004 v8.0163 QA70-6554 EXTRACT_VARS_FROM_FILENAME
	///Button 	m_chkRenameWks ;
	/// end EXTRACT_VARS_FROM_FILENAME
	//Button 	m_chkWks ;			///Danice 12/12/03 BUTTON_DEFINED_NOT_USE
///	Button 	m_SourASCII;
	Button 	m_radMatrix ;
	Button 	m_radWndNone ;

	/// EJP 2005-08-15 v8.0288 QA70-7996 IMPWIZ_SUPPORT_XFUNC
	Button m_radWks;
	ComboBox m_cbXFuncs;
	/// end IMPWIZ_SUPPORT_XFUNC
	
	Edit 	m_ebDescrip ;
	
	/// SY 01/04/2005 QA70-6555 v8.0181 USING_MULTI_OPEN_FDLOG
	///Edit 	m_editFileName ;
	BOOL m_bFileNameChanged;
	ComboBox m_editFileName;
	/// end USING_MULTI_OPEN_FDLOG
	ComboBox m_cbFilters ;
	ComboBox m_cbWksTemplate ;

	/// EJP 01-04-2005 v8.0181 QA70-6555 NEW_IMPORT_MODES
    ComboBox m_cbImportMode;
    /// end NEW_IMPORT_MODES
	
	/// EJP 06-08-2004 v8.0886 QA70-5417 IMPROVE_DATA_CHANGE_DETECTION
	string m_strDataFileOnActive;
	int m_nDataSourceOnActive;
	/// end IMPROVE_DATA_CHANGE_DETECTION
	
	/// EJP 11-11-2004 v8.0163 QA70-6554 EXTRACT_VARS_FROM_FILENAME
	///	/// EJP 07-07-2004 v8.0903 QA70-6555 SUPPORT_WORKBOOK_IMPWIZ
	///	Button m_chkRenWkbk;
	///	Button m_chkFNameToWkbkComments;
	///	Button m_chkFNameToColComments;
	///	Button m_chkIncludePath;
	///	/// end SUPPORT_WORKBOOK_IMPWIZ
	/// end EXTRACT_VARS_FROM_FILENAME
};

/// EJP 11-11-2004 v8.0163 QA70-6554 EXTRACT_VARS_FROM_FILENAME
class IWFileNameOptionsPage : public ImpWizardPage
{
public:
	DWORD OnShowStatus(DWORD InternalStatus);

	EVENTS_BEGIN
		PAGE_ON_INIT(OnInit)
		PAGE_ON_ACTIVE(OnActive)
		PAGE_ON_KILLACTIVE(OnKillActive)

		ON_BN_CLICKED(IDC_AUTO_RENAME, OnClickAutoRename) ///---Sim 02-01-2007 ADD_AUTO_RENAME
		ON_BN_CLICKED(IDC_REN_WKS_TO_FILE_NAME, OnClickRenWksToFName)
		/// Hong 02/27/07 QA80-9410 MORE_RENAME_WORKSHEET_WITH_VARIABLE
		//ON_BN_CLICKED(IDC_REN_WKS_TO_FIRST_VARIABLE, OnClickRenWksWithFirstVar) // Hong 02/26/07 ADD_WORKSHEET_TO_FIRST_VARIABLE
		ON_BN_CLICKED(IDC_REN_WKS_TO_VARIABLE, OnClickRenWksWithVar)
		/// end MORE_RENAME_WORKSHEET_WITH_VARIABLE
		ON_BN_CLICKED(IDC_REN_WKBK_TO_FILE_NAME, OnClickRenWkbkToFName)
		ON_BN_CLICKED(IDC_REN_WKBK_TO_VARIABLE, OnClickRenWkbkWithVar) ///---Sim 03-06-2007 MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
		ON_BN_CLICKED(IDC_REN_WKBK_LONG_NAME_ONLY, OnClickRenWkbkLnOnly) ///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
		ON_BN_CLICKED(IDC_RENAME_FILE_PATH, OnClickRenWkbkFPath) ///---Sim 02-25-2007 ADD_OPTION_FILE_PATH_FOR_WORKBOOK
		ON_BN_CLICKED(IDC_APPEND_FILE_NAME_TO_WKS_COMM, OnClickAppendFNameToWkbkComm)
		ON_BN_CLICKED(IDC_APPEND_FILE_NAME_TO_COL_COMM, OnClickAppendFNameToColComm)
		ON_BN_CLICKED(IDC_APPEND_FILE_PATH, OnClickAppendFPath)
	EVENTS_END

	//----------------------------------------------------------------------
	// Methods for handling events
	//----------------------------------------------------------------------
	BOOL OnInit();
	BOOL OnActive();
	BOOL OnKillActive();

	BOOL OnClickAutoRename(Control ctrl); ///---Sim 02-01-2007 ADD_AUTO_RENAME
	BOOL OnClickRenWksToFName(Control ctrl);
	/// Hong 02/27/07 QA80-9410 MORE_RENAME_WORKSHEET_WITH_VARIABLE
	//BOOL OnClickRenWksWithFirstVar(Control ctrl); // Hong 02/26/07 ADD_WORKSHEET_TO_FIRST_VARIABLE
	BOOL OnClickRenWksWithVar(Control ctrl);
	/// end MORE_RENAME_WORKSHEET_WITH_VARIABLE
	BOOL OnClickRenWkbkToFName(Control ctrl);
	BOOL OnClickRenWkbkWithVar(Control ctrl); ///---Sim 03-06-2007 MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
	BOOL OnClickRenWkbkLnOnly(Control ctrl); ///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
	BOOL OnClickRenWkbkFPath(Control ctrl); ///---Sim 02-25-2007 ADD_OPTION_FILE_PATH_FOR_WORKBOOK
	BOOL OnClickAppendFNameToWkbkComm(Control ctrl);
	BOOL OnClickAppendFNameToColComm(Control ctrl);
	BOOL OnClickAppendFPath(Control ctrl);

	//----------------------------------------------------------------------
	// Methods for
	//----------------------------------------------------------------------
	void EnableFlag(DWORD dwFlag, BOOL bEnable);
	void FilterToDialog();
	
	void EnableCtrl(); ///---Sim 02-01-2007 ADD_AUTO_RENAME

private:
	Button m_chkAutoRename; ///---Sim 02-01-2007 ADD_AUTO_RENAME
	Button m_chkRenWksToFName;
	/// Hong 02/27/07 QA80-9410 MORE_RENAME_WORKSHEET_WITH_VARIABLE
	//Button m_chkRenWkbkToFirstVar; // Hong 02/26/07 ADD_WORKSHEET_TO_FIRST_VARIABLE
	Button m_chkRenWksWithVar;
	Edit m_ebWksVarName;
	/// end MORE_RENAME_WORKSHEET_WITH_VARIABLE
	Button m_chkRenWkbkToFName;
	///---Sim 03-06-2007 MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
	Button m_chkRenWkbkWithVar;
	Edit m_ebWkbkVarName;
	///---END MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
	Button m_chkRenWkbkLnOnly; ///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
	Button m_chkRenWkbkFPath; ///---Sim 02-25-2007 ADD_OPTION_FILE_PATH_FOR_WORKBOOK
	Button m_chkAppendFNameToWkbkComm;
	Button m_chkAppendFNameToColComm;
	Button m_chkAppendFPath;
	
	// These controls are only visible for Binary and User Defined filters
	Control m_grpExtractVar;
	Button m_chkExtractByDelim;
	Button m_chkExtractByPos;
};
/// end EXTRACT_VARS_FROM_FILENAME
